// loadlibrary.cpp : Defines the entry point for the console application.
//

#include "stdio.h"
#include "stdafx.h"
#include "windows.h"

/* Define access layer DLL name */
#define ACCESS_ROUTINES_DLL_NAME    TEXT("user_access.dll")

/* Define access layer DLL name */
#define OS_RAPPER_DLL_NAME          TEXT("user_os.dll")

/* Utility DLL name */
#define UTIL_DLL_NAME               TEXT("dimage_dll.Dll")

/* Declaration of the DLL entry points types */
typedef int (* dll_ExMain)( int argc,char **argv);
typedef int (* dll_ExSetRapperFileName)( LPCSTR lpLibFileName);

/****************************/
/****************************/
/***                      ***/  
/***   Main entry point   ***/
/***                      ***/
/****************************/
/****************************/

int main(int argc, char** argv)
{
  HINSTANCE hDll    = NULL;

  int       ret_val = 0;

  dll_ExMain pfn_main                      = NULL;
  dll_ExSetRapperFileName pfn_AccessRapper = NULL;
  dll_ExSetRapperFileName pfn_OsRapper     = NULL;


  /**********************************/
  /* Dynamically Load Utility's DLL */
  /**********************************/

  hDll =  LoadLibrary(UTIL_DLL_NAME);
  if(hDll == NULL)
  {
     printf("Failed locating dimage_dll.dll\r\n\n");
     printf("Please make sure it is in the search path.\r\n\n");
     return 1001; /* Failed locating DLL */
  }


  /********************************************************************/
  /* Declare DLL file containing the access layer routines - Optional */
  /********************************************************************/

  pfn_AccessRapper   = (dll_ExSetRapperFileName)GetProcAddress(hDll, TEXT("ExSetAccessRapperFileName"));
  if(pfn_AccessRapper)
  {
      //Call Dll function to set Access rapper routines
      ret_val = pfn_AccessRapper(ACCESS_ROUTINES_DLL_NAME);
      if(ret_val)
      {
         goto FREE_DLL_AND_EXIT;
      }
  }
  else /* Use default DLL file */
  {
     printf("Using Default Access routine DLL file\r\n\n");
  }

  /*******************************************************************/
  /* Declare DLL file containing the OS specific routines - Optional */
  /*******************************************************************/

  pfn_OsRapper   = (dll_ExSetRapperFileName)GetProcAddress(hDll, TEXT("ExSetOSRapperFileName"));
  if(pfn_OsRapper)
  {
      //Call Dll function to set OS rapper routines
      ret_val = pfn_OsRapper(OS_RAPPER_DLL_NAME);
      if(ret_val)
      {
         goto FREE_DLL_AND_EXIT;
      }
  }
  else
  {
     printf("Using Default Os Wrapper DLL file\r\n\n");
  }

  /************************************************/
  /* Call the utility with the required arguments */
  /************************************************/

  //Get pointer to DLL  exported ExMainDll function.
  pfn_main   = (dll_ExMain)GetProcAddress(hDll, TEXT("ExMainDll"));
  if(pfn_main)
  {
     //Call Dll function
     ret_val = pfn_main(argc,argv);
  }
  else
  {
     printf("Failed locating ExMainDll Entry point\r\n\n");
     ret_val = 1002; /* Failed locating ExMainDll */
  }

FREE_DLL_AND_EXIT:   

  FreeLibrary((HINSTANCE)hDll);
  hDll = NULL;
  
  if(ret_val)
  {
     printf("Returned status is %d\r\n",ret_val);
  }
  return ret_val;
}
